VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   3120
   ClientLeft      =   60
   ClientTop       =   420
   ClientWidth     =   4680
   LinkTopic       =   "Form1"
   ScaleHeight     =   3120
   ScaleWidth      =   4680
   StartUpPosition =   2  'Bildschirmmitte
   Begin VB.CommandButton Command1 
      Caption         =   "Create PDF"
      Height          =   855
      Left            =   960
      TabIndex        =   0
      Top             =   960
      Width           =   2775
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private Declare Function GetFullPathName Lib "kernel32" Alias "GetFullPathNameW" (ByVal lpFileName As Long, ByVal nBufferLength As Long, ByVal lpBuffer As Long, ByVal lpFilePart As Long) As Long
Private Declare Function ShellExecuteA Lib "shell32.dll" (ByVal hWnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long

Public WithEvents PDF As CPDF 'Activate event support
Attribute PDF.VB_VarHelpID = -1

Private Function GetFileBuffer(FilePath As String) As Byte()
   Dim Data() As Byte
   Dim fnum As Integer
   fnum = FreeFile(0)
   Open FilePath For Binary Access Read As #1
   ReDim Data(LOF(fnum) - 1)
   Get fnum, , Data
   Close fnum
   GetFileBuffer = Data
End Function

Function GetFullPath(ByVal Path As String) As String
   Dim sLen As Long
   GetFullPath = Space(512)
   sLen = GetFullPathName(StrPtr(Path), 511, StrPtr(GetFullPath), 0)
   GetFullPath = Left(GetFullPath, sLen)
End Function

Private Sub PDF_Error(ByVal Description As String, ByVal ErrType As Long, DoBreak As Boolean)
   MsgBox Description, vbExclamation, "Error"
   DoBreak = False ' Try to continue
End Sub

Private Function HaveEInvoice(ByVal PDF As CPDF, ByVal InFileName As String) As Boolean
   HaveEInvoice = False
   Dim info As TPDFVersionInfo

   Call PDF.CreateNewPDF(vbNullString)
   ' We need the document info or metadata and embedded files only
   Call PDF.SetImportFlags(TImportFlags.ifDocInfo Or TImportFlags.ifEmbeddedFiles)
   Call PDF.SetImportFlags2(TImportFlags2.if2UseProxy)
   If PDF.OpenImportFile(InFileName, TPwdType.ptOpen, vbNullString) < 0 Then GoTo finish

   ' Other stuff can be ignored
   Call PDF.ImportCatalogObjects

   If Not PDF.GetPDFVersionEx(info) Then GoTo finish

   If info.PDFAVersion = 3 And info.FXDocName <> "" Then
      Dim ef As Integer
      Dim fs As TPDFFileSpec
      ef = PDF.FindEmbeddedFile(info.FXDocName)
      If ef < 0 Then
         MsgBox "Invoice " & info.FXDocName & " not found!", vbExclamation, "Error"
         GoTo finish
      End If
      If ef <> 0 Then
         MsgBox "Warning: The invoice should be the first file attachment. This might cause unnecessary problems.\n", vbExclamation, "Warning"
      End If
      HaveEInvoice = PDF.GetEmbeddedFile(ef, fs, True) And fs.BufSize > 0
   End If
finish:
   Call PDF.FreePDF
End Function

Private Function CreateInvoice(ByVal PDF As CPDF, ByVal FacturX As Boolean, ByVal InvoiceName As String, ByVal OutFile As String) As Boolean
   Dim ef As Long
   CreateInvoice = False
   ' The output file is opened later
   Call PDF.CreateNewPDF(vbNullString)

   ' We assume that the PDF invoice is already a valid PDF/A 3 file in this example.

   Call PDF.SetImportFlags(TImportFlags.ifImportAsPage Or TImportFlags.ifImportAll)
   If PDF.OpenImportFile("../../../test_files/test_invoice.pdf", TPwdType.ptOpen, vbNullString) < 0 Then GoTo finish

   Call PDF.ImportPDFFile(1, 1#, 1#)

   ' The test invoice has the file name factur-x.xml. This is the right name for FacturX and ZUGFeRD output.
   ' However, for XRechnung the file name must be xrechnung.xml. So, we must be able to change the file
   ' name to get this example working. We could rename the input file but the usage of AttachFileEx() is probably
   ' more elegant.

   ' It is not of interest here whether the xml file is a valid ZUGFeRD or XRechnung. This example shows how the
   ' PDF container must be created and how to extract the xml invoice from an arbitrary e-invoice.

   Dim buffer() As Byte

   buffer = GetFileBuffer("../../../test_files/factur-x.xml")

   ' The invoice name of a XRechnung might be xrechnung.xml or factur-x.xml. Both names must work with DynaPDF.
   ef = PDF.AttachFileEx(buffer, InvoiceName, "EN 19631 compliant invoice", False)

   Erase buffer

   If FacturX Then
      ' Note that ZUGFeRD 2.1 or higher and FacturX is identically defined in PDF. Therefore, both formats share
      ' the same version constants. Note also that the profiles Minimum, Basic, and Basic WL are not fully EN 16931
      ' compliant, and hence cannot be used to create e-invoices.
      Call PDF.SetPDFVersion(TPDFVersion.pvFacturX_Comfort)
      Call PDF.AssociateEmbFile(TAFDestObject.adCatalog, -1, TAFRelationship.arAlternative, ef)
   Else
      Call PDF.SetPDFVersion(TPDFVersion.pvFacturX_XRechnung)
      Call PDF.AssociateEmbFile(TAFDestObject.adCatalog, -1, TAFRelationship.arSource, ef)
   End If

   ' No fatal error occurred?
   If PDF.HaveOpenDoc() Then
      ' OK, now we can open the output file.
      If Not PDF.OpenOutputFile(OutFile) Then GoTo finish
      CreateInvoice = PDF.CloseFile()
   End If

finish:
   Call PDF.FreePDF
End Function

Private Sub Command1_Click()

   Dim OutFile As String
   OutFile = App.Path & "\out.pdf"

   ' Test cases:
   ' - ZUGFeRD or FacturX
   ' - XRechnung -> The invoice name must be xrechnung.xml
   If Not CreateInvoice(PDF, True, "factur-x.xml", OutFile) Or Not HaveEInvoice(PDF, OutFile) _
   Or Not CreateInvoice(PDF, False, "xrechnung.xml", OutFile) Or Not HaveEInvoice(PDF, OutFile) Then
      MsgBox "XML Invoice not found!", vbExclamation, "Error"
   Else
      MsgBox "All tests passed!", vbInfo, "Information"
   End If
End Sub

Private Sub Form_Load()
   On Error GoTo Err
   Set PDF = New CPDF
   ' Set the license key here if you have one
   ' Call pdf.SetLicenseKey("")

   ' Non embedded CID fonts depend usually on the availability of external cmaps.
   ' External cmaps should be loaded if possible.
   Call PDF.SetCMapDir(GetFullPath("../../../Resource/CMap"), TLoadCMapFlags.lcmDelayed Or TLoadCMapFlags.lcmRecursive)
   Exit Sub
Err:
   MsgBox "Out of memory!", vbCritical, "Fatal error"
End Sub

Private Sub Form_Terminate()
   Set PDF = Nothing
End Sub
